#ifdef PRECOMPUTE_TRANSMITTANCE
	layout(location = 0) out vec3 transmittance;
	
	uniform sampler2D transmittance_texture0;
	uniform sampler2D transmittance_texture1;
#endif

#ifdef PRECOMPUTE_MULTIPLE_SCATTERING
    layout(location = 0) out vec4 scattering;
  
    uniform sampler3D scattering_texture0;
	uniform sampler3D scattering_texture1;
    uniform int layer;
#endif

uniform float alpha;
uniform float texW;
uniform float texH;
uniform float texD;

void main() 
{
	#ifdef PRECOMPUTE_TRANSMITTANCE
		transmittance=mix(texture(transmittance_texture0,gl_FragCoord.xy/vec2(texW,texH)).rgb,texture(transmittance_texture1,gl_FragCoord.xy/vec2(texW,texH)).rgb,alpha);
	#endif
	#ifdef PRECOMPUTE_MULTIPLE_SCATTERING
		scattering=mix(texture(scattering_texture0,vec3(gl_FragCoord.xy,layer+0.5)/vec3(texW,texH,texD)),texture(scattering_texture1,vec3(gl_FragCoord.xy, layer+0.5)/vec3(texW,texH,texD)),alpha);
	#endif
}
